﻿#include  "StdAfx.h"

#include  "EventHandle.hpp"
#include  <szRuntimeException.hpp>

using namespace szpp;

EventHandle::EventHandle() : m_hEvent(0)
{
  m_hEvent = CreateEvent(0, TRUE, FALSE, 0);
  if (0 == m_hEvent)
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot create event")));
}

EventHandle::EventHandle(HANDLE hEvent)
{
}

EventHandle::~EventHandle()
{
  if (0 != m_hEvent)
    CloseHandle(m_hEvent);
}

EventHandle::operator HANDLE()
{
  return m_hEvent;
}

void EventHandle::Wait() const
{
  Wait(INFINITE);
}

bool EventHandle::Wait(u32 timeout) const
{
  bool retval = (WAIT_OBJECT_0 == WaitForSingleObject(m_hEvent, timeout));
  return retval;
  //return (WAIT_OBJECT_0 == WaitForSingleObject(m_hEvent, timeout));
}

void EventHandle::Set()
{
  SetEvent(m_hEvent);
}

void EventHandle::Reset()
{
  ResetEvent(m_hEvent);
}
